/////////////////////////////////////////////////////////////////////////////////

// Original obtained from GlsSandbox.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// The originals of these shaders did not take gl_FragCoord.w  into
// account so the iStripper scale attribute would  have  no  effect
// when used ina scene node that used one of them. I have therefore
// performed a global replace to substitute scaled_gl_FragCoord for
// gl_FragCoord and declare it here. TheEmu 2016/12/15

#define scaled_gl_FragCoord vec4(gl_FragCoord.xyz*gl_FragCoord.w,1.0)

// Use defines here rather than edit the body of the code.

#define time u_Elapsed
#define resolution u_WindowSize
#define mouse vec2(0.0,0.0)
#define surfacePosition vec2(2.0*scaled_gl_FragCoord.xy/resolution-1.0)

/////////////////////////////////////////////////////////////////////////////////

#ifdef GL_ES
precision mediump float;
#endif

// uniform float time;
// uniform vec2 mouse;
// uniform vec2 resolution;
// varying vec2 surfacePosition;

float rand(vec2 n) { 
	return fract(cos(dot(n, vec2(12.9898, 4.1414))) * 43758.5453);
}
float noise(vec2 n) {
	const vec2 d = vec2(0.0, 1.0);
	vec2 b = floor(n), f = smoothstep(vec2(0.0), vec2(1.0), fract(n));
	return mix(mix(rand(b), rand(b + d.yx), f.x), mix(rand(b + d.xy), rand(b + d.yy), f.x), f.y);
}
float fbm(vec2 n) {
	float total = 0.0, amplitude = 1.0;
	for (int i = 0; i < 4; i++) {
		total += noise(n) * amplitude;
		n += n;
		amplitude *= 0.5;
	}
	return total * 0.5;
}

void main( void ) {

	vec2 p = surfacePosition;
	vec3 c = vec3(0);
	float a = atan(p.x,p.y);
	float r = length(p);
	float cb = abs(sign(fract(p.x*10.)-0.5)+sign(fract(p.y*10.)-0.5)); //chessboard
	c.r = fbm(p*10.+fbm(p*10.)*10.+vec2(cos(time),sin(time))*2.);
	
	gl_FragColor = vec4( c, 1.0 );
   gl_FragColor *= gl_Color; // TheEmu 2016/12/15

}